package com.ejie.p06b.model;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.dao.solreclamacion.P06bAltaMediadoresDao;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BGeneralManager;
import com.ejie.p06b.manager.P06bMng;
//import com.ejie.p06b.manager.contextSubmissionEvent.ApplicantInfoEvent;
//import com.ejie.p06b.manager.contextSubmissionEvent.ContextSubmissionEvent;
//import com.ejie.p06b.manager.contextSubmissionEvent.NoticeChannelEvent;
//import com.ejie.p06b.manager.contextSubmissionEvent.NoticeEvent;
//import com.ejie.p06b.manager.contextSubmissionEvent.NoticesEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.ApplicantInfoEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.ContextSubmissionEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.NoticeChannelEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.NoticeEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.NoticesEvent;
import com.ejie.p06b.manager.detailInfo.DetailInfo;
import com.ejie.p06b.manager.detailInfo.DetailInfo.DatosMediador.*;
import com.ejie.p06b.manager.ejgvDocument.EjgvDocument;
import com.ejie.p06b.manager.ejgvDocument.Person;
import com.ejie.p06b.manager.ejgvDocument.Persons;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.dao.solreclamacion.P06bAltaMediadoresDao;
import com.ejie.p06b.exception.P06BModMediadorException;


public class DatosMediadores {
	
	//Datos basicos
	private String titRazonSocial = "";
	private String titNombre = "";
	private String titApe1 = "";
	private String titApe2 = "";
	private String titTipoId = "";
	private String titId = "";
	private String titSexo = "";
	private String repNombre = "";
	private String repApe1 = "";
	private String repApe2 = "";
	private String repTipoId = "";
	private String repId = "";
	//Canal de Notificacion/comunicacion
	private int tipoNotif = -1;//Tipo canal seleccionado (1-Electronico, 2-Postal)
	//Avisos
	private String tipoAviso = "";//Tipo aviso seleccionado (1-Correo electrnico, 2-SMS)
	private String valorAviso = ""; //Si Tipo aviso seleccionado=1-->direccion de correo electronico.Si Tipo aviso seleccionado=2-->Nmero de telefono.  
	
	//Avisos
	private String idiomaSol = ""; //Idioma de notificaciones, comunicaciones y avisos  
	
	//Fecha de Efectos
	private String fechaEfectos = "";//Fecha de Efectos
	
	//Datos mediador
	private List<P06B61T00Datatype> listP06B61T00Datatype;
	//Domicilio actividad
	private byte dATipoMediador=-1;
	private String dAProvincia = "";
	private String dAMunicipio = "";
	private String dALocalidad = "";
	private String dACalle = "";
	private String dAPortal = "";
	private String dAPiso = "";
	private String dALetra = "";
	private String dACodigoPostal = "";
	private String dATelefono = "";
	private String dAEMail = "";
	private String dAWeb = "";
	//Atencin cliente
	private String aCTAtencioncliente = "";
	//Titular
	private String aCTNombre = "";
	private String aCTApe1 = "";
	private String aCTApe2 = "";
	private byte aCTTipoId;
	private String aCTId = "";
	//Defensor
	private String aCDNombre = "";
	private String aCDApe1 = "";
	private String aCDApe2 = "";
	private byte aCDTipoId;
	private String aCDId = "";

	//Participacion significativa
	private String pSCapitalSocial = "";
	private String pSNumeroParticipaciones = "";
	private List<P06B22T00Datatype> listP06B22T00Datatype;
	private List<P06B24T00Datatype> listP06B24T00DatatypeOD;
	private List<P06B24T00Datatype> listP06B24T00DatatypeA;

	//Capacidad financiera
	private byte cFDeclaro;
	private float cFImpFondos;
	private float cFImpCapacidad;
	private boolean cFContrataSeguro;
	private String cFTextoSeguro = "";
	private boolean cFContrataAval;
	private String cFTextoAval = "";
	
	private Integer codReclamante=-1;
	
	private String nombreRclte = "";

	private int expediente; //expediente
	private String expedienteFormateado = ""; //expediente formateado para la cancelacin donde no se recibe el tipo de mediador
	private Integer duplicado=0; //Posible nmero de expediente duplicado. 0: No duplicado; 1: Duplicado; 2: Acumular
	
//	private int codSolicitud = -1;//Cdigo de solicitud
	private String idSolTramitagune = "";  //ID que ha dado Tramitagune a la Solicitud. Servir para comunicarse con Tramitagune-

	/*Indicadores de cara a la modificacin por Tramitagune de si 
	las diferentes secciones de la modificacin deben actualizarse o no*/ 
	private boolean bActualizarDomicilioSocial;
	private boolean bActualizarCapitalSocial;
	private boolean bActualizarAdministradores;
	private boolean bActualizarOrganoDireccion;
	private boolean bActualizarAtencionDefensaCliente;
	private boolean bActualizarCapacidadFinanciera;
	private boolean bActualizarEntidadesVinculadas;
	
	//Motivo cancelacin
	private byte motivoCancelacionRadio;
	private String otrosMotivos = "";
	/**
	 * Constructor utilizado por el procedimiento de alta
	 * @throws SQLException 
	 * @throws P06BModMediadorException 
	 */
	public DatosMediadores(int nextExpediente, P06bAltaMediadoresDao p06bDao, EjgvDocument ejgvDocument, ContextSubmissionEvent cData, P06B64T00Datatype p06B64T000Datatype) throws P06BModMediadorException, SQLException {
		
		P06BLog.send(0,this, "(AltaMediadores) Creacin del objeto con los datos de negocio parseados");
		
		DetailInfo detailInfo = ejgvDocument.getBody().getDetailInfo();
		DetailInfo.DatosMediador datosMediador = detailInfo.getDatosMediador();
		dATipoMediador = datosMediador.getGrupotipomediador().getListatipoMediador();

		Persons persons = ejgvDocument.getBody().getApplicantInfo().getPersons();
		
		if (persons!=null){
			List<Person> listPerson = persons.getPerson();
			if (listPerson!=null){
				int numPersonas = listPerson.size();
				int i = 0;
				Person person = null;
				while (i<numPersonas){
					person = listPerson.get(i); 
					if(person!=null){
						if(person.getPersonType()!=null){
							if(person.getHolderShip().equals("HOLDER")){
								titTipoId = person.getPersonType();
								if(titTipoId.equals("2")){
									//Si es un CIF (PersonType=2) en maysculas.
									titRazonSocial = person.getName().toUpperCase();
								}else{
									titApe1 = person.getApe1().toUpperCase();
									titApe2 = person.getApe2().toUpperCase();
									titNombre = person.getName().toUpperCase();
								}
								titId = person.getId().toUpperCase();
							}else if(person.getHolderShip().equals("REPRESENTATIVE")){
								repTipoId = person.getPersonType();
								if(repTipoId.equals("2")){
									//Si es un CIF (PersonType=2) en maysculas.
									repNombre = person.getName().toUpperCase();
								}else{
									repApe1 = person.getApe1().toUpperCase();
									repApe2 = person.getApe2().toUpperCase();
									repNombre = person.getName().toUpperCase();
								}
								repId = person.getId().toUpperCase();
							}
						}						
					}
					i++;
				}			
			}
		}
		
		this.expediente = nextExpediente;
		
		
		idSolTramitagune = cData.getSolicitudID(); //Recoger el ID que ha dado tramitagune a la solicitud
		
		p06B64T000Datatype.setExpediente(this.formatearExpediente());

		p06bDao.ExcepcionPorIdentificadorEnExpedienteEstadoNoBaja(titId);
		
		//Tipo de notificacin (Electronica o Postal)
		ApplicantInfoEvent applicantInfoEvent = cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0); 

		tipoNotif = Integer.parseInt(applicantInfoEvent.getNotificationEvent().getChannelType());
		
		//Avisos
		NoticesEvent noticesEvent = applicantInfoEvent.getNoticesEvent(); 
		if (noticesEvent!=null){
			List<NoticeEvent> listNoticeEvent = noticesEvent.getNoticeEvent();
			if (listNoticeEvent!=null){
				NoticeChannelEvent noticeChannelEvent = null;
				noticeChannelEvent = listNoticeEvent.get(0).getNoticeChannelEvent();
				if (noticeChannelEvent!=null){
					tipoAviso = noticeChannelEvent.getNoticeType();
					if (tipoAviso!= null){
						if (tipoAviso.equals("1")){
							//Ha seleccionado aviso por email
							valorAviso=noticeChannelEvent.getEmailAddress();
						}else if (tipoAviso.equals("2")){
							//Ha seleccionado aviso por SMS
							valorAviso=noticeChannelEvent.getSmsNumber();
						}
					}
				}
			}
		}
		
		//Idioma
		idiomaSol = applicantInfoEvent.getLanguage();
		
		//Obtener la fecha de Efectos en el caso de que se la solicitud se presentara previamente en otro organismo
		if (cData!=null && cData.getRegistrySubmissionTimestamp()!=null){
			fechaEfectos=cData.getRegistrySubmissionTimestamp();
		}
		if (fechaEfectos==null || fechaEfectos.equalsIgnoreCase("")){
			Date dateAhora = new Date();
			fechaEfectos = P06BFecha.getFecha(dateAhora) + " " + P06BFecha.getHoraCompleta(dateAhora);
		}
		
		DetailInfo.DatosMediador.DireccionActividad direccionActividad = datosMediador.getDireccionActividad();
		dAProvincia = direccionActividad.getListaProvincia();
		dAMunicipio = direccionActividad.getListaMunicipio();
//		dALocalidad = direccionActividad.getListaLocalidad();
//
//		if (dALocalidad.length()>0){
//			//dALocalidad = dALocalidad.substring(dALocalidad.length()-1, dALocalidad.length());
//			dALocalidad = P06BGeneralManager.getInstance().sustituirLocNORAPorLocFCA(direccionActividad.getListaLocalidad());
//		}
		
		dACalle = direccionActividad.getCampoBasicoCalle().toUpperCase();
		dAPortal = direccionActividad.getCampoBasicoPortal().toUpperCase();
		dAPiso = direccionActividad.getCampoBasicoPiso().toUpperCase();
		dALetra = direccionActividad.getCampoBasicoLetra().toUpperCase();
		dACodigoPostal = direccionActividad.getCampoBasicoCp().toUpperCase();
		dATelefono = direccionActividad.getCampoBasicoTfno().toUpperCase();
		dAEMail = direccionActividad.getCampoBasicoemail().toUpperCase();
		dAWeb = direccionActividad.getCampoBasicoweb().toUpperCase();
		
		Attcliente attcliente = datosMediador.getAttcliente();
		aCTAtencioncliente = attcliente.getAtencioncliente();
		if (aCTAtencioncliente!=null){
			DetailInfo.DatosMediador.Attcliente.DatostitularServicioAtt datostitularServicioAtt = attcliente.getDatostitularServicioAtt(); 
			aCTTipoId = datostitularServicioAtt.getTipoDni();
			aCTId = datostitularServicioAtt.getDni().toUpperCase();
			aCTNombre = datostitularServicioAtt.getNombreTitular().toUpperCase();
			aCTApe1 = datostitularServicioAtt.getApe1Titular().toUpperCase();
			aCTApe2 = datostitularServicioAtt.getApe2Titular().toUpperCase();
			//datostitularServicioAtt.getDatosdefensorCliente();
			DetailInfo.DatosMediador.Attcliente.DatosdefensorCliente datosdefensorCliente = attcliente.getDatosdefensorCliente(); 
			aCDTipoId = datosdefensorCliente.getTipoDniDefensor();
			aCDId = datosdefensorCliente.getDniDefensor().toUpperCase();
			aCDNombre = datosdefensorCliente.getNombreDefensor().toUpperCase();
			aCDApe1 = datosdefensorCliente.getApe1Defensor().toUpperCase();
			aCDApe2 = datosdefensorCliente.getApe2Defensor().toUpperCase();			
		}
		
		DetailInfo.ParticipacionSignificativa participacionSignificativa = detailInfo.getParticipacionSignificativa();

		//Socios Participantes
		DetailInfo.ParticipacionSignificativa.SociosParticipantes sociosParticipantes = participacionSignificativa.getSociosParticipantes();
		P06BLog.send(0,this, "sociosParticipantes.getCapitalSocialImporteCampo():" + sociosParticipantes.getCapitalSocialImporteCampo());
		pSCapitalSocial = sociosParticipantes.getCapitalSocialImporteCampo();
		pSCapitalSocial = pSCapitalSocial.replaceAll("\\.", "");
		P06BLog.send(0,this, "pSCapitalSocial:" + pSCapitalSocial);
//		pSCapitalSocial = pSCapitalSocial.replaceAll(",", ".");
		P06BLog.send(0,this, "pSCapitalSocial:" + pSCapitalSocial);
		pSNumeroParticipaciones = sociosParticipantes.getCapitalSocialAccionesCampo();
		pSNumeroParticipaciones = pSNumeroParticipaciones.replaceAll("\\.", "");
		DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR sociosParticipacionDenominacionGR = sociosParticipantes.getSociosParticipacionDenominacionGR();
		
		if (sociosParticipacionDenominacionGR!= null){
			listP06B22T00Datatype = new ArrayList<P06B22T00Datatype>(); 
			int i = 0;
			List<DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR.ElementoGRValores> listElementoGRValores = sociosParticipacionDenominacionGR.getElementoGRValores();
			List<DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR.ElementoGR> listElementoGR = sociosParticipacionDenominacionGR.getElementoGR();
			while (i<listElementoGRValores.size()){
				P06B22T00Datatype p06B22T00Datatype = new P06B22T00Datatype();
				p06B22T00Datatype.setTipo("1");
				p06B22T00Datatype.setNExpediente(this.formatearExpediente());
				p06B22T00Datatype.setIdentificador(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacion().toUpperCase());
				String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getSociosParticipacionTipoIdentificacion());
				p06B22T00Datatype.setTipo1(sTipoPersona);
				if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
					p06B22T00Datatype.setRazSoc(listElementoGR.get(i).getSociosParticipacionDenominacion().toUpperCase());
					p06B22T00Datatype.setIdRep(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacionDniRepresentante().toUpperCase());
					p06B22T00Datatype.setNomRep(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacionNombreRepresentante().toUpperCase());
				}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
					String nombreApConcatenados = listElementoGR.get(i).getSociosParticipacionDenominacion().toUpperCase();
					int longitud = nombreApConcatenados.length();
					int comp = ((Integer)longitud).compareTo(50);
					int hasta = 0;
					if (comp<0){
						hasta = longitud;
					}else{
						hasta = 50;
					}
					if (longitud>0){
						p06B22T00Datatype.setNombre(nombreApConcatenados.substring(0, hasta));
						if (longitud>50){
							comp = ((Integer)longitud).compareTo(100);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 100;
							}
							p06B22T00Datatype.setApe1(nombreApConcatenados.substring(50, hasta));						
							if (longitud>100){
								comp = ((Integer)longitud).compareTo(150);
								hasta = 0;
								if (comp<0){
									hasta = longitud;
								}else{
									hasta = 150;
								}
								p06B22T00Datatype.setApe2(nombreApConcatenados.substring(100, hasta));
							}
						}
					}
				}
				p06B22T00Datatype.setParticipa(listElementoGR.get(i).getSociosParticipacionPorcentaje());
				p06B22T00Datatype.setFecAlta(listElementoGR.get(i).getSociosParticipacionAlta());
				listP06B22T00Datatype.add(p06B22T00Datatype);
				i++;
			}
		}
		
		//Organo Responsable
		DetailInfo.ParticipacionSignificativa.OrganoResponsable organoResponsable = participacionSignificativa.getOrganoResponsable();
		DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR organoResponsableGR = organoResponsable.getOrganoResponsableGR();
		
		if (organoResponsableGR!= null){
			listP06B24T00DatatypeOD = new ArrayList<P06B24T00Datatype>(); 
			int i = 0;
			List<DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR.ElementoGRValores> listElementoGRValores = organoResponsableGR.getElementoGRValores();
			List<DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR.ElementoGR> listElementoGR = organoResponsableGR.getElementoGR();
			while (i<listElementoGRValores.size()){
				P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
				p06B24T00Datatype.setTipo(P06BConstantes.P06B_CARGOS_ORGANODIRECCIONRESPONSABLE);
				p06B24T00Datatype.setnExpediente(this.formatearExpediente());
				p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getOrganoResponsableDenominacionIdentificacion().toUpperCase());
				String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getOrganoResponsableTipoIdentificacion());
//				p06B24T00Datatype.setTipo1(sTipoPersona);
				String nombreORazonSocialEnchurrada = "";
				if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getOrganoResponsableDenominacion().toUpperCase();
//					String nombreApConcatenados = listElementoGR.get(i).getOrganoResponsableDenominacion();
//					int longitud = nombreApConcatenados.length();
//					int comp = ((Integer)longitud).compareTo(50);
//					int hasta = 0;
//					if (comp<0){
//						hasta = longitud;
//					}else{
//						hasta = 50;
//					}
//					if (longitud>0){
//						p06B24T00Datatype.setNombre(nombreApConcatenados.substring(0, hasta));
//						if (longitud>50){
//							comp = ((Integer)longitud).compareTo(100);
//							hasta = 0;
//							if (comp<0){
//								hasta = longitud;
//							}else{
//								hasta = 100;
//							}
//							p06B24T00Datatype.setApe1(nombreApConcatenados.substring(50, hasta));						
//							if (longitud>100){
//								comp = ((Integer)longitud).compareTo(150);
//								hasta = 0;
//								if (comp<0){
//									hasta = longitud;
//								}else{
//									hasta = 150;
//								}
//								p06B24T00Datatype.setApe2(nombreApConcatenados.substring(100, hasta));
//							}
//						}
//					}
				}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//					p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getOrganoResponsableDenominacion());				
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getOrganoResponsableDenominacion().toUpperCase();
				}
				int longitud = nombreORazonSocialEnchurrada.length();
				int comp = ((Integer)longitud).compareTo(50);
				int hasta = 0;
				if (comp<0){
					hasta = longitud;
				}else{
					hasta = 50;
				}
				if (longitud>0){
					p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
					if (longitud>50){
						comp = ((Integer)longitud).compareTo(100);
						hasta = 0;
						if (comp<0){
							hasta = longitud;
						}else{
							hasta = 100;
						}
						p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
						if (longitud>100){
							comp = ((Integer)longitud).compareTo(150);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 150;
							}
							p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
						}
					}
				}

				p06B24T00Datatype.setFechNom(listElementoGR.get(i).getOrganoResponsableNombramiento());
				String sCurso = "NO";
				String sDenCurso = "";
				switch (listElementoGRValores.get(i).getOrganoResponsableFormacion()){
					case 1:
						sCurso = "SI";
						sDenCurso = listElementoGR.get(i).getOrganoResponsableFormacion().toUpperCase();
						break;
					case 2: 
						sCurso = "SI";
						sDenCurso = listElementoGR.get(i).getOrganoResponsableFormacion().toUpperCase();
						break;
				}
				p06B24T00Datatype.setCurso(sCurso);
				p06B24T00Datatype.setDenCurso(sDenCurso);
				p06B24T00Datatype.setAcreditaH("SI");
				p06B24T00Datatype.setIdCargo(listElementoGRValores.get(i).getOrganoResponsableCargo());
//				p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getOrganoResponsableCargo());
				
				listP06B24T00DatatypeOD.add(p06B24T00Datatype);
				i++;
			}
		}
		
		//Organo Direccion
		DetailInfo.DatosMediador.OrganoDireccion organoDireccion = datosMediador.getOrganoDireccion();
		DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas grupoPersonas = organoDireccion.getGrupoPersonas();
		
		if (grupoPersonas!= null){
			listP06B24T00DatatypeOD = new ArrayList<P06B24T00Datatype>(); 
			int i = 0;
			List<DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas.ElementoGRValores> listElementoGRValores = grupoPersonas.getElementoGRValores();
			List<DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas.ElementoGR> listElementoGR = grupoPersonas.getElementoGR();
			while (i<listElementoGRValores.size()){
				P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
				p06B24T00Datatype.setTipo(P06BConstantes.P06B_CARGOS_ORGANODIRECCIONRESPONSABLE);
				p06B24T00Datatype.setnExpediente(this.formatearExpediente());
				p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getDni().toUpperCase());
				String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getTipoPersonaCargoOrgano());
//				p06B24T00Datatype.setTipo1(sTipoPersona);
				String nombreORazonSocialEnchurrada = "";
				if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getNombre().toUpperCase();
//					String nombreApConcatenados = listElementoGR.get(i).getNombre();
//					int longitud = nombreApConcatenados.length();
//					int comp = ((Integer)longitud).compareTo(50);
//					int hasta = 0;
//					if (comp<0){
//						hasta = longitud;
//					}else{
//						hasta = 50;
//					}
//					if (longitud>0){
//						p06B24T00Datatype.setNombre(nombreApConcatenados.substring(0, hasta));
//						if (longitud>50){
//							comp = ((Integer)longitud).compareTo(100);
//							hasta = 0;
//							if (comp<0){
//								hasta = longitud;
//							}else{
//								hasta = 100;
//							}
//							p06B24T00Datatype.setApe1(nombreApConcatenados.substring(50, hasta));						
//							if (longitud>100){
//								comp = ((Integer)longitud).compareTo(150);
//								hasta = 0;
//								if (comp<0){
//									hasta = longitud;
//								}else{
//									hasta = 150;
//								}
//								p06B24T00Datatype.setApe2(nombreApConcatenados.substring(100, hasta));
//							}
//						}
//					}
				}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//					p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getNombre());				
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getNombre().toUpperCase();
				}
				int longitud = nombreORazonSocialEnchurrada.length();
				int comp = ((Integer)longitud).compareTo(50);
				int hasta = 0;
				if (comp<0){
					hasta = longitud;
				}else{
					hasta = 50;
				}
				if (longitud>0){
					p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
					if (longitud>50){
						comp = ((Integer)longitud).compareTo(100);
						hasta = 0;
						if (comp<0){
							hasta = longitud;
						}else{
							hasta = 100;
						}
						p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
						if (longitud>100){
							comp = ((Integer)longitud).compareTo(150);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 150;
							}
							p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
						}
					}
				}

				p06B24T00Datatype.setFechNom(listElementoGR.get(i).getFechaNombramiento());
				p06B24T00Datatype.setIdCargo("0");
//				p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getCargo());
				p06B24T00Datatype.setPais(((Byte)listElementoGRValores.get(i).getNacionalidad()).toString());
				p06B24T00Datatype.setProfesi(listElementoGR.get(i).getProfesionOrgano());
				
				listP06B24T00DatatypeOD.add(p06B24T00Datatype);
				i++;
			}
		}
		
		//Administradores
		DetailInfo.ParticipacionSignificativa.Administradores administradores = participacionSignificativa.getAdministradores();
		DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR administradoresGR = administradores.getAdministradoresGR();
		
		if (administradoresGR!= null){
			listP06B24T00DatatypeA = new ArrayList<P06B24T00Datatype>(); 
			int i = 0;
			List<DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR.ElementoGRValores> listElementoGRValores = administradoresGR.getElementoGRValores();
			List<DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR.ElementoGR> listElementoGR = administradoresGR.getElementoGR();
			while (i<listElementoGRValores.size()){
				P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
				p06B24T00Datatype.setTipo(P06BConstantes.P06B_CARGOS_ADMINISTRADOR);
				p06B24T00Datatype.setnExpediente(this.formatearExpediente());
				p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getAdministradoresDenominacionIdentificacion().toUpperCase());
				String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getAdministradoresTipoIdentificacion());
//				p06B24T00Datatype.setTipo1(sTipoPersona);
				String nombreORazonSocialEnchurrada = "";
				if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getAdministradoresDenominacion().toUpperCase();
//					String nombreApConcatenados = listElementoGR.get(i).getAdministradoresDenominacion();
//					int longitud = nombreApConcatenados.length();
//					int comp = ((Integer)longitud).compareTo(50);
//					int hasta = 0;
//					if (comp<0){
//						hasta = longitud;
//					}else{
//						hasta = 50;
//					}
//					if (longitud>0){
//						p06B24T00Datatype.setNombre(nombreApConcatenados.substring(0, hasta));
//						if (longitud>50){
//							comp = ((Integer)longitud).compareTo(100);
//							hasta = 0;
//							if (comp<0){
//								hasta = longitud;
//							}else{
//								hasta = 100;
//							}
//							p06B24T00Datatype.setApe1(nombreApConcatenados.substring(50, hasta));						
//							if (longitud>100){
//								comp = ((Integer)longitud).compareTo(150);
//								hasta = 0;
//								if (comp<0){
//									hasta = longitud;
//								}else{
//									hasta = 150;
//								}
//								p06B24T00Datatype.setApe2(nombreApConcatenados.substring(100, hasta));
//							}
//						}
//					}
				}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
					nombreORazonSocialEnchurrada = listElementoGR.get(i).getAdministradoresDenominacion().toUpperCase();
//					p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getAdministradoresDenominacion());
//					p06B24T00Datatype.setIdRep(listElementoGR.get(i).getAdministradoresDniRepresentante());
//					p06B24T00Datatype.setNomRep(listElementoGR.get(i).getAdministradoresNombreRepresentante());
				}
				int longitud = nombreORazonSocialEnchurrada.length();
				int comp = ((Integer)longitud).compareTo(50);
				int hasta = 0;
				if (comp<0){
					hasta = longitud;
				}else{
					hasta = 50;
				}
				if (longitud>0){
					p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
					if (longitud>50){
						comp = ((Integer)longitud).compareTo(100);
						hasta = 0;
						if (comp<0){
							hasta = longitud;
						}else{
							hasta = 100;
						}
						p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
						if (longitud>100){
							comp = ((Integer)longitud).compareTo(150);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 150;
							}
							p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
						}
					}
				}

				p06B24T00Datatype.setFechNom(listElementoGR.get(i).getAdministradoresNombramiento());
				p06B24T00Datatype.setAcreditaH("SI");
				p06B24T00Datatype.setIdCargo(listElementoGRValores.get(i).getAdministradoresCargo());
//				p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getAdministradoresCargo());
				
				listP06B24T00DatatypeA.add(p06B24T00Datatype);
				i++;
			}
		}
		
		//Empresas Vinculadas
		DetailInfo.DatosMediador.Empresasvinculadas empresavinculada = datosMediador.getEmpresasvinculadas();
		DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR empresasVinculadasGR = empresavinculada.getEmpresasVinculadasGR();
		
		if (empresasVinculadasGR!= null){
			listP06B61T00Datatype = new ArrayList<P06B61T00Datatype>(); 
			int i = 0;
			List<DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGRValores> listElementoGRValores = empresasVinculadasGR.getElementoGRValores();
			List<DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGR> listElementoGR = empresasVinculadasGR.getElementoGR();
//			while (i<listElementoGRValores.size()){
			while (i<listElementoGR.size()){
				DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGR elementoGR = listElementoGR.get(i);
//				DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGRValores elementoGRValores = listElementoGRValores.get(i);
				P06B61T00Datatype p06B61T00Datatype = new P06B61T00Datatype();
				p06B61T00Datatype.setExpedi(this.formatearExpediente());
				p06B61T00Datatype.setCif(elementoGR.getCif().trim().toUpperCase());
				p06B61T00Datatype.setEntidad(elementoGR.getDenominacionEmpresa().toUpperCase());
//				p06B61T00Datatype.setCalle(elementoGR.getCampoBasicoCalleEmpresa());
//				p06B61T00Datatype.setPortal(elementoGR.getCampoBasicoPortalEmpresa());
//				p06B61T00Datatype.setPiso(elementoGR.getCampoBasicoPisoEmpresa());
//				p06B61T00Datatype.setLetra(elementoGR.getCampoBasicoLetraEmpresa());
				
//				p06B61T00Datatype.setCodpro(elementoGRValores.getListaProvinciaEmpresa());
//				p06B61T00Datatype.setCodmun(elementoGRValores.getListaMunicipioEmpresa());

//				String localidad = elementoGRValores.getListaLocalidadEmpresa();
//				if (localidad.length()>0){
//					localidad = P06BGeneralManager.getInstance().sustituirLocNORAPorLocFCA(localidad);
//				}
//				p06B61T00Datatype.setLocali(localidad);
//				p06B61T00Datatype.setCodpst(elementoGR.getCampoBasicoCpEmpresa());
				p06B61T00Datatype.setClavecat(elementoGR.getDgs().trim().toUpperCase());
				
				listP06B61T00Datatype.add(p06B61T00Datatype);
				i++;
			}
		}
		
		String declaroCapacidad = datosMediador.getCapacidad().getDeclarocapacidad();
		if (declaroCapacidad==null||declaroCapacidad.equals("")){
			cFDeclaro = 0;
		}else{
			cFDeclaro = Byte.parseByte(declaroCapacidad);
		}
		if (cFDeclaro==P06BConstantes.P06B_CF_DEBECUMPLIMENTAR){
			DetailInfo.CapacidadFinanciera capacidadFinanciera = detailInfo.getCapacidadFinanciera();
			DetailInfo.CapacidadFinanciera.CalculoCapacidadFinanciera calculoCapacidadFinanciera = capacidadFinanciera.getCalculoCapacidadFinanciera();
			String sImpFondos = calculoCapacidadFinanciera.getImporteFondosPerdidos();
			if (sImpFondos!=null){
				sImpFondos = sImpFondos.replace(',', '.');
				cFImpFondos = Float.parseFloat(sImpFondos);
			}else{
				cFImpFondos = 0.0f;				
			}
			String sImpCap = calculoCapacidadFinanciera.getImporteCapacidad();
			if (sImpCap!=null){
				sImpCap = sImpCap.replace(',', '.');
				cFImpCapacidad = Float.parseFloat(sImpCap);
			}else{
				cFImpCapacidad = 0.0f;				
			}
			if (calculoCapacidadFinanciera.getContrataAval().getAval().getElementoaval()>0 && calculoCapacidadFinanciera.getContrataAval().getAval().getElementoaval()<3){
				cFTextoAval = calculoCapacidadFinanciera.getContrataAval().getAvalCampo().toUpperCase();
				cFContrataAval = true;
			}else{
				cFContrataAval = false;
			}
			if (calculoCapacidadFinanciera.getContrataAval().getSeguro().getElementoseguro()>0 && calculoCapacidadFinanciera.getContrataAval().getSeguro().getElementoseguro()<3){
				cFTextoSeguro = calculoCapacidadFinanciera.getContrataAval().getContrataSeguro().toUpperCase(); 
				cFContrataSeguro = true;
			}else{
				cFContrataSeguro = false;
			}
			
		}
		
		P06BLog.send(0,this, "(AltaMediadores) Objeto con los datos de negocio parseados creado correctamente");
		
	}


	
	/**
	 * Constructor utilizado por el procedimiento de modificacin
	 * @throws SQLException 
	 * @throws P06BModMediadorException 
	 */
	public DatosMediadores(P06bAltaMediadoresDao p06bDao, EjgvDocument ejgvDocument, ContextSubmissionEvent cData, P06B64T00Datatype p06B64T000Datatype) throws SQLException, P06BModMediadorException {
		
		P06BLog.send(0,this, "(AltaMediadores) Creacin del objeto con los datos de negocio parseados");
		
		DetailInfo detailInfo = ejgvDocument.getBody().getDetailInfo();
		DetailInfo.DatosMediador datosMediador = detailInfo.getDatosMediador();
		this.dATipoMediador = datosMediador.getGrupotipomediador().getListatipoMediador();

		if (this.dATipoMediador==-1){
			throw new P06BModMediadorException("No se pud determinar el tipo de mediador del mediador.");
		}
		
		Persons persons = ejgvDocument.getBody().getApplicantInfo().getPersons();
		
		if (persons!=null){
			List<Person> listPerson = persons.getPerson();
			if (listPerson!=null){
				int numPersonas = listPerson.size();
				int i = 0;
				Person person = null;
				while (i<numPersonas){
					person = listPerson.get(i); 
					if(person!=null){
						if(person.getPersonType()!=null){
							if(person.getHolderShip().equals("HOLDER")){
								titTipoId = person.getPersonType();
								if(titTipoId.equals("2")){
									//Si es un CIF (PersonType=2) en maysculas.
									titRazonSocial = person.getName().toUpperCase();
								}else{
									titApe1 = person.getApe1().toUpperCase();
									titApe2 = person.getApe2().toUpperCase();
									titNombre = person.getName().toUpperCase();
								}
								titId = person.getId().toUpperCase();
							}else if(person.getHolderShip().equals("REPRESENTATIVE")){
								repTipoId = person.getPersonType();
								if(repTipoId.equals("2")){
									//Si es un CIF (PersonType=2) en maysculas.
									repNombre = person.getName().toUpperCase();
								}else{
									repApe1 = person.getApe1().toUpperCase();
									repApe2 = person.getApe2().toUpperCase();
									repNombre = person.getName().toUpperCase();
								}
								repId = person.getId().toUpperCase();
							}
						}						
					}
					i++;
				}			
			}
		}

		if (this.titId==null || "".equals(this.titId.trim())){
			throw new P06BModMediadorException("No se recibe el identificador del mediador.");
		}
		
		this.expediente = p06bDao.getExpedienteModificado(titId, obtenerClaseMediador());
		
		p06B64T000Datatype.setExpediente(this.formatearExpediente());

//		if (this.expediente==null){
//			throw new P06BModMediadorException("No se pud determinar el expediente modificado");
//		}
		
		idSolTramitagune = cData.getSolicitudID(); //Recoger el ID que ha dado tramitagune a la solicitud
		
		//Tipo de notificacin (Electronica o Postal)
		ApplicantInfoEvent applicantInfoEvent = cData.getApplicantsInfoEvent().getApplicantInfoEvent().get(0); 

		tipoNotif = Integer.parseInt(applicantInfoEvent.getNotificationEvent().getChannelType());
		
		//Avisos
		NoticesEvent noticesEvent = applicantInfoEvent.getNoticesEvent(); 
		if (noticesEvent!=null){
			List<NoticeEvent> listNoticeEvent = noticesEvent.getNoticeEvent();
			if (listNoticeEvent!=null){
				NoticeChannelEvent noticeChannelEvent = null;
				noticeChannelEvent = listNoticeEvent.get(0).getNoticeChannelEvent();
				if (noticeChannelEvent!=null){
					tipoAviso = noticeChannelEvent.getNoticeType();
					if (tipoAviso!= null){
						if (tipoAviso.equals("1")){
							//Ha seleccionado aviso por email
							valorAviso=noticeChannelEvent.getEmailAddress();
						}else if (tipoAviso.equals("2")){
							//Ha seleccionado aviso por SMS
							valorAviso=noticeChannelEvent.getSmsNumber();
						}
					}
				}
			}
		}
		
		//Idioma
		idiomaSol = applicantInfoEvent.getLanguage();
		
		//Obtener la fecha de Efectos en el caso de que se la solicitud se presentara previamente en otro organismo
		if (cData!=null && cData.getRegistrySubmissionTimestamp()!=null){
			fechaEfectos=cData.getRegistrySubmissionTimestamp();
		}
		if (fechaEfectos==null || fechaEfectos.equalsIgnoreCase("")){
			Date dateAhora = new Date();
			fechaEfectos = P06BFecha.getFecha(dateAhora) + " " + P06BFecha.getHoraCompleta(dateAhora);
		}
		
		bActualizarDomicilioSocial = false;
		// En la primera condicin se examina el check de tramitagune para mediadores J 'Domicilio social'
		// En la segunda el check de tramitagune para mediadores F 'Modificacin domicilio profesional'
		// Este curiosamente viene en el campo ElementoaccionistasProfesionalesCheck
		if (datosMediador.getGruposDatosModificables().getGrupoAccionistasPD().getChkDomicilioSoc().getElementochkDomicilioSoc()==1 || 
			datosMediador.getGruposDatosModificables().getAccionistasProfesionalesCheck().getElementoaccionistasProfesionalesCheck()==1){
			bActualizarDomicilioSocial = true;		
			DetailInfo.DatosMediador.DireccionActividad direccionActividad = datosMediador.getDireccionActividad();
			dAProvincia = direccionActividad.getListaProvincia();
			dAMunicipio = direccionActividad.getListaMunicipio();
//			dALocalidad = direccionActividad.getListaLocalidad();
	//
//			if (dALocalidad.length()>0){
//				//dALocalidad = dALocalidad.substring(dALocalidad.length()-1, dALocalidad.length());
//				dALocalidad = P06BGeneralManager.getInstance().sustituirLocNORAPorLocFCA(direccionActividad.getListaLocalidad());
//			}
			
			dACalle = direccionActividad.getCampoBasicoCalle().toUpperCase();
			dAPortal = direccionActividad.getCampoBasicoPortal().toUpperCase();
			dAPiso = direccionActividad.getCampoBasicoPiso().toUpperCase();
			dALetra = direccionActividad.getCampoBasicoLetra().toUpperCase();
			dACodigoPostal = direccionActividad.getCampoBasicoCp().toUpperCase();
			dATelefono = direccionActividad.getCampoBasicoTfno().toUpperCase();
			dAEMail = direccionActividad.getCampoBasicoemail().toUpperCase();
			dAWeb = direccionActividad.getCampoBasicoweb().toUpperCase();
		}
		p06B64T000Datatype.setbActualizarDomicilioSocial(bActualizarDomicilioSocial);
		
		bActualizarAtencionDefensaCliente = false;
		if (datosMediador.getGruposDatosModificables().getServicioAtencionClienteCheck().getElementoservicioAtencionClienteCheck()==1){
			bActualizarAtencionDefensaCliente = true;		
			Attcliente attcliente = datosMediador.getAttcliente();
			aCTAtencioncliente = attcliente.getAtencioncliente();
			DetailInfo.DatosMediador.Attcliente.DatostitularServicioAtt datostitularServicioAtt = attcliente.getDatostitularServicioAtt(); 
			aCTTipoId = datostitularServicioAtt.getTipoDni();
			aCTId = datostitularServicioAtt.getDni().toUpperCase();
			aCTNombre = datostitularServicioAtt.getNombreTitular().toUpperCase();
			aCTApe1 = datostitularServicioAtt.getApe1Titular().toUpperCase();
			aCTApe2 = datostitularServicioAtt.getApe2Titular().toUpperCase();
			//datostitularServicioAtt.getDatosdefensorCliente();
			DetailInfo.DatosMediador.Attcliente.DatosdefensorCliente datosdefensorCliente = attcliente.getDatosdefensorCliente(); 
			aCDTipoId = datosdefensorCliente.getTipoDniDefensor();
			aCDId = datosdefensorCliente.getDniDefensor().toUpperCase();
			aCDNombre = datosdefensorCliente.getNombreDefensor().toUpperCase();
			aCDApe1 = datosdefensorCliente.getApe1Defensor().toUpperCase();
			aCDApe2 = datosdefensorCliente.getApe2Defensor().toUpperCase();
		}
		p06B64T000Datatype.setbActualizarAtencionDefensaCliente(bActualizarAtencionDefensaCliente);		
		
		DetailInfo.ParticipacionSignificativa participacionSignificativa = detailInfo.getParticipacionSignificativa();

		//Socios Participantes
		bActualizarCapitalSocial = false;
		if (datosMediador.getGruposDatosModificables().getGrupoAccionistasPD().getChkCapSoc().getElementochkCapSoc()==1){
			bActualizarCapitalSocial = true;		
			DetailInfo.ParticipacionSignificativa.SociosParticipantes sociosParticipantes = participacionSignificativa.getSociosParticipantes();
			pSCapitalSocial = sociosParticipantes.getCapitalSocialImporteCampo();
			pSCapitalSocial = pSCapitalSocial.replaceAll("\\.", "");
			P06BLog.send(0,this, "pSCapitalSocial:" + pSCapitalSocial);
//			pSCapitalSocial = pSCapitalSocial.replaceAll(",", ".");
			P06BLog.send(0,this, "pSCapitalSocial:" + pSCapitalSocial);
			pSNumeroParticipaciones = sociosParticipantes.getCapitalSocialAccionesCampo();
			pSNumeroParticipaciones = pSNumeroParticipaciones.replaceAll("\\.", "");
			DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR sociosParticipacionDenominacionGR = sociosParticipantes.getSociosParticipacionDenominacionGR();
			
			if (sociosParticipacionDenominacionGR!= null){
				listP06B22T00Datatype = new ArrayList<P06B22T00Datatype>(); 
				int i = 0;
				List<DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR.ElementoGRValores> listElementoGRValores = sociosParticipacionDenominacionGR.getElementoGRValores();
				List<DetailInfo.ParticipacionSignificativa.SociosParticipantes.SociosParticipacionDenominacionGR.ElementoGR> listElementoGR = sociosParticipacionDenominacionGR.getElementoGR();
				while (i<listElementoGRValores.size()){
					P06B22T00Datatype p06B22T00Datatype = new P06B22T00Datatype();
					p06B22T00Datatype.setTipo("1");
					p06B22T00Datatype.setNExpediente(this.formatearExpediente());
					p06B22T00Datatype.setIdentificador(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacion().toUpperCase());
					String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getSociosParticipacionTipoIdentificacion());
					p06B22T00Datatype.setTipo1(sTipoPersona);
					if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
						String nombreApConcatenados = listElementoGR.get(i).getSociosParticipacionDenominacion().toUpperCase();
						int longitud = nombreApConcatenados.length();
						int comp = ((Integer)longitud).compareTo(50);
						int hasta = 0;
						if (comp<0){
							hasta = longitud;
						}else{
							hasta = 50;
						}
						if (longitud>0){
							p06B22T00Datatype.setNombre(nombreApConcatenados.substring(0, hasta));
							if (longitud>50){
								comp = ((Integer)longitud).compareTo(100);
								hasta = 0;
								if (comp<0){
									hasta = longitud;
								}else{
									hasta = 100;
								}
								p06B22T00Datatype.setApe1(nombreApConcatenados.substring(50, hasta));						
								if (longitud>100){
									comp = ((Integer)longitud).compareTo(150);
									hasta = 0;
									if (comp<0){
										hasta = longitud;
									}else{
										hasta = 150;
									}
									p06B22T00Datatype.setApe2(nombreApConcatenados.substring(100, hasta));
								}
							}
						}
					}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
						p06B22T00Datatype.setRazSoc(listElementoGR.get(i).getSociosParticipacionDenominacion().toUpperCase());
						p06B22T00Datatype.setIdRep(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacionDniRepresentante().toUpperCase());
						p06B22T00Datatype.setNomRep(listElementoGR.get(i).getSociosParticipacionDenominacionIdentificacionNombreRepresentante().toUpperCase());
					}
					p06B22T00Datatype.setParticipa(listElementoGR.get(i).getSociosParticipacionPorcentaje());
					p06B22T00Datatype.setFecAlta(listElementoGR.get(i).getSociosParticipacionAlta());
					listP06B22T00Datatype.add(p06B22T00Datatype);
					i++;
				}
			}
		}
		p06B64T000Datatype.setbActualizarCapitalSocial(bActualizarCapitalSocial);
		
		bActualizarOrganoDireccion = false;
		if (datosMediador.getGruposDatosModificables().getOrganoDireccionCheck().getElementoorganoDireccionCheck()==1){
			bActualizarOrganoDireccion = true;		
			
			//Organo de Direccion Responsable
			DetailInfo.ParticipacionSignificativa.OrganoResponsable organoResponsable = participacionSignificativa.getOrganoResponsable();
			DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR organoResponsableGR = organoResponsable.getOrganoResponsableGR();
			
			if (organoResponsableGR!= null){
				listP06B24T00DatatypeOD = new ArrayList<P06B24T00Datatype>(); 
				int i = 0;
				List<DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR.ElementoGRValores> listElementoGRValores = organoResponsableGR.getElementoGRValores();
				List<DetailInfo.ParticipacionSignificativa.OrganoResponsable.OrganoResponsableGR.ElementoGR> listElementoGR = organoResponsableGR.getElementoGR();
				while (i<listElementoGRValores.size()){
					P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
					p06B24T00Datatype.setTipo("1");
					p06B24T00Datatype.setnExpediente(this.formatearExpediente());
					p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getOrganoResponsableDenominacionIdentificacion().toUpperCase());
					String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getOrganoResponsableTipoIdentificacion());
//					p06B24T00Datatype.setTipo1(sTipoPersona);
					String nombreORazonSocialEnchurrada = "";
					if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getOrganoResponsableDenominacion().toUpperCase();
					}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//						p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getOrganoResponsableDenominacion());				
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getOrganoResponsableDenominacion().toUpperCase();
					}
					int longitud = nombreORazonSocialEnchurrada.length();
					int comp = ((Integer)longitud).compareTo(50);
					int hasta = 0;
					if (comp<0){
						hasta = longitud;
					}else{
						hasta = 50;
					}
					if (longitud>0){
						p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
						if (longitud>50){
							comp = ((Integer)longitud).compareTo(100);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 100;
							}
							p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
							if (longitud>100){
								comp = ((Integer)longitud).compareTo(150);
								hasta = 0;
								if (comp<0){
									hasta = longitud;
								}else{
									hasta = 150;
								}
								p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
							}
						}
					}

					p06B24T00Datatype.setFechNom(listElementoGR.get(i).getOrganoResponsableNombramiento());
					String sCurso = "NO";
					String sDenCurso = "";
					switch (listElementoGRValores.get(i).getOrganoResponsableFormacion()){
						case 1:
							sCurso = "SI";
							sDenCurso = listElementoGR.get(i).getOrganoResponsableFormacion().toUpperCase();
							break;
						case 2: 
							sCurso = "SI";
							sDenCurso = listElementoGR.get(i).getOrganoResponsableFormacion().toUpperCase();
							break;
					}
					p06B24T00Datatype.setCurso(sCurso);
					p06B24T00Datatype.setDenCurso(sDenCurso);
					p06B24T00Datatype.setAcreditaH("SI");
					p06B24T00Datatype.setIdCargo(listElementoGRValores.get(i).getOrganoResponsableCargo());
//					p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getOrganoResponsableCargo());
					
					listP06B24T00DatatypeOD.add(p06B24T00Datatype);
					i++;
				}
			}

			//Organo Direccion
			DetailInfo.DatosMediador.OrganoDireccion organoDireccion = datosMediador.getOrganoDireccion();
			DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas grupoPersonas = organoDireccion.getGrupoPersonas();
			
			if (grupoPersonas!= null){
				listP06B24T00DatatypeOD = new ArrayList<P06B24T00Datatype>(); 
				int i = 0;
				List<DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas.ElementoGRValores> listElementoGRValores = grupoPersonas.getElementoGRValores();
				List<DetailInfo.DatosMediador.OrganoDireccion.GrupoPersonas.ElementoGR> listElementoGR = grupoPersonas.getElementoGR();
				while (i<listElementoGRValores.size()){
					P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
					p06B24T00Datatype.setTipo("1");
					p06B24T00Datatype.setnExpediente(this.formatearExpediente());
					p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getDni().toUpperCase());
					String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getTipoPersonaCargoOrgano());
//					p06B24T00Datatype.setTipo1(sTipoPersona);
					String nombreORazonSocialEnchurrada = "";
					if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getNombre().toUpperCase();
					}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getNombre().toUpperCase();
//						p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getNombre());				
					}
					int longitud = nombreORazonSocialEnchurrada.length();
					int comp = ((Integer)longitud).compareTo(50);
					int hasta = 0;
					if (comp<0){
						hasta = longitud;
					}else{
						hasta = 50;
					}
					if (longitud>0){
						p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
						if (longitud>50){
							comp = ((Integer)longitud).compareTo(100);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 100;
							}
							p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
							if (longitud>100){
								comp = ((Integer)longitud).compareTo(150);
								hasta = 0;
								if (comp<0){
									hasta = longitud;
								}else{
									hasta = 150;
								}
								p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
							}
						}
					}

					p06B24T00Datatype.setFechNom(listElementoGR.get(i).getFechaNombramiento());
					p06B24T00Datatype.setIdCargo("0");
//					p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getCargo());
					p06B24T00Datatype.setPais(((Byte)listElementoGRValores.get(i).getNacionalidad()).toString());
					p06B24T00Datatype.setProfesi(listElementoGR.get(i).getProfesionOrgano());
					
					listP06B24T00DatatypeOD.add(p06B24T00Datatype);
					i++;
				}
			}
		}
		p06B64T000Datatype.setbActualizarOrganoDireccion(bActualizarOrganoDireccion);
		
		
		bActualizarAdministradores = false;
		if (datosMediador.getGruposDatosModificables().getGrupoAccionistasPD().getChkAdmin().getElementochkAdmin()==1){
			bActualizarAdministradores = true;		
			//Administradores
			DetailInfo.ParticipacionSignificativa.Administradores administradores = participacionSignificativa.getAdministradores();
			DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR administradoresGR = administradores.getAdministradoresGR();
			
			if (administradoresGR!= null){
				listP06B24T00DatatypeA = new ArrayList<P06B24T00Datatype>(); 
				int i = 0;
				List<DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR.ElementoGRValores> listElementoGRValores = administradoresGR.getElementoGRValores();
				List<DetailInfo.ParticipacionSignificativa.Administradores.AdministradoresGR.ElementoGR> listElementoGR = administradoresGR.getElementoGR();
				while (i<listElementoGRValores.size()){
					P06B24T00Datatype p06B24T00Datatype = new P06B24T00Datatype();
					p06B24T00Datatype.setTipo("4");
					p06B24T00Datatype.setnExpediente(this.formatearExpediente());
					p06B24T00Datatype.setIdentificador(listElementoGR.get(i).getAdministradoresDenominacionIdentificacion().toUpperCase());
					String sTipoPersona = obtenerTipoPersonaEnBaseATipoIdTramitagune(listElementoGRValores.get(i).getAdministradoresTipoIdentificacion());
//					p06B24T00Datatype.setTipo1(sTipoPersona);
					String nombreORazonSocialEnchurrada = "";
					if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_FISICA)){
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getAdministradoresDenominacion().toUpperCase();
					}else if (sTipoPersona.equals(P06BConstantes.P06B_PERSONA_JURIDICA)){
//						p06B24T00Datatype.setRazSoc(listElementoGR.get(i).getAdministradoresDenominacion());
						nombreORazonSocialEnchurrada = listElementoGR.get(i).getAdministradoresDenominacion().toUpperCase();
//						p06B24T00Datatype.setIdRep(listElementoGR.get(i).getAdministradoresDniRepresentante());
//						p06B24T00Datatype.setNomRep(listElementoGR.get(i).getAdministradoresNombreRepresentante());
					}
					int longitud = nombreORazonSocialEnchurrada.length();
					int comp = ((Integer)longitud).compareTo(50);
					int hasta = 0;
					if (comp<0){
						hasta = longitud;
					}else{
						hasta = 50;
					}
					if (longitud>0){
						p06B24T00Datatype.setNombre(nombreORazonSocialEnchurrada.substring(0, hasta));
						if (longitud>50){
							comp = ((Integer)longitud).compareTo(100);
							hasta = 0;
							if (comp<0){
								hasta = longitud;
							}else{
								hasta = 100;
							}
							p06B24T00Datatype.setApe1(nombreORazonSocialEnchurrada.substring(50, hasta));						
							if (longitud>100){
								comp = ((Integer)longitud).compareTo(150);
								hasta = 0;
								if (comp<0){
									hasta = longitud;
								}else{
									hasta = 150;
								}
								p06B24T00Datatype.setApe2(nombreORazonSocialEnchurrada.substring(100, hasta));
							}
						}
					}

					p06B24T00Datatype.setFechNom(listElementoGR.get(i).getAdministradoresNombramiento());
					p06B24T00Datatype.setAcreditaH("SI");
					p06B24T00Datatype.setIdCargo(listElementoGRValores.get(i).getAdministradoresCargo());
//					p06B24T00Datatype.setDenCargo(listElementoGR.get(i).getAdministradoresCargo());
					
					listP06B24T00DatatypeA.add(p06B24T00Datatype);
					i++;
				}
			}
		}
		p06B64T000Datatype.setbActualizarAdministradores(bActualizarAdministradores);
		
		//Empresas Vinculadas
		bActualizarEntidadesVinculadas = false;
		if (datosMediador.getGruposDatosModificables().getEmpresasVinculacionCheck().getElementoempresasVinculacionCheck()==1){
			bActualizarEntidadesVinculadas = true;		
			DetailInfo.DatosMediador.Empresasvinculadas empresavinculada = datosMediador.getEmpresasvinculadas();
			DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR empresasVinculadasGR = empresavinculada.getEmpresasVinculadasGR();
			
			if (empresasVinculadasGR!= null){
				listP06B61T00Datatype = new ArrayList<P06B61T00Datatype>(); 
				int i = 0;
//				List<DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGRValores> listElementoGRValores = empresasVinculadasGR.getElementoGRValores();
				List<DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGR> listElementoGR = empresasVinculadasGR.getElementoGR();
				while (i<listElementoGR.size()){
					DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGR elementoGR = listElementoGR.get(i);
//					DetailInfo.DatosMediador.Empresasvinculadas.EmpresasVinculadasGR.ElementoGRValores elementoGRValores = listElementoGRValores.get(i);
					P06B61T00Datatype p06B61T00Datatype = new P06B61T00Datatype();
					p06B61T00Datatype.setExpedi(this.formatearExpediente());
					p06B61T00Datatype.setCif(elementoGR.getCif().trim().toUpperCase());
					p06B61T00Datatype.setEntidad(elementoGR.getDenominacionEmpresa().toUpperCase());
//					p06B61T00Datatype.setCodpro(elementoGRValores.getListaProvinciaEmpresa());
//					p06B61T00Datatype.setCodmun(elementoGRValores.getListaMunicipioEmpresa());
					p06B61T00Datatype.setClavecat(elementoGR.getDgs().trim().toUpperCase());
					p06B61T00Datatype.setAltaBaja(elementoGR.getAltaBaja());
					
					listP06B61T00Datatype.add(p06B61T00Datatype);
					i++;
				}
			}
		}
		p06B64T000Datatype.setbActualizarEntidadesVinculadas(bActualizarEntidadesVinculadas);
		

		bActualizarCapacidadFinanciera = false;
		if (datosMediador.getGruposDatosModificables().getCapacidadFinancieraCheck().getElementocapacidadFinancieraCheck()==1){
			bActualizarCapacidadFinanciera = true;		
			String declaroCapacidad = datosMediador.getCapacidad().getDeclarocapacidad();
			if (declaroCapacidad==null||declaroCapacidad.equals("")){
				cFDeclaro = 0;
			}else{
				cFDeclaro = Byte.parseByte(declaroCapacidad);
			}
			if (cFDeclaro==P06BConstantes.P06B_CF_DEBECUMPLIMENTAR){
				DetailInfo.CapacidadFinanciera capacidadFinanciera = detailInfo.getCapacidadFinanciera();
				DetailInfo.CapacidadFinanciera.CalculoCapacidadFinanciera calculoCapacidadFinanciera = capacidadFinanciera.getCalculoCapacidadFinanciera();
				String sImpFondos = calculoCapacidadFinanciera.getImporteFondosPerdidos();
				if (sImpFondos!=null){
					sImpFondos = sImpFondos.replace(',', '.');
					cFImpFondos = Float.parseFloat(sImpFondos);
				}else{
					cFImpFondos = 0.0f;				
				}
				String sImpCap = calculoCapacidadFinanciera.getImporteCapacidad();
				if (sImpCap!=null){
					sImpCap = sImpCap.replace(',', '.');
					cFImpCapacidad = Float.parseFloat(sImpCap);
				}else{
					cFImpCapacidad = 0.0f;				
				}
				if (calculoCapacidadFinanciera.getContrataAval().getAval().getElementoaval()>0 && calculoCapacidadFinanciera.getContrataAval().getAval().getElementoaval()<3){
					cFTextoAval = calculoCapacidadFinanciera.getContrataAval().getAvalCampo().toUpperCase();
					cFContrataAval = true;
				}else{
					cFContrataAval = false;
				}
				if (calculoCapacidadFinanciera.getContrataAval().getSeguro().getElementoseguro()>0 && calculoCapacidadFinanciera.getContrataAval().getSeguro().getElementoseguro()<3){
					cFTextoSeguro = calculoCapacidadFinanciera.getContrataAval().getContrataSeguro().toUpperCase(); 
					cFContrataSeguro = true;
				}else{
					cFContrataSeguro = false;
				}
				
			}
		}
		p06B64T000Datatype.setbActualizarCapacidadFinanciera(bActualizarCapacidadFinanciera);
		
		P06BLog.send(0,this, "(AltaMediadores) Objeto con los datos de negocio parseados creado correctamente");
		
	}


	
	/**
	 * Constructor utilizado por el procedimiento de modificacin
	 * @throws SQLException 
	 * @throws P06BModMediadorException 
	 */
	public DatosMediadores(P06bAltaMediadoresDao p06bDao, EjgvDocument ejgvDocument, ContextSubmissionEvent cData, P06B64T00Datatype p06B64T000Datatype, int ii) throws SQLException, P06BModMediadorException {
		
		P06BLog.send(0,this, "(AutMediadores) Creacin del objeto con los datos de negocio parseados");
		
		DetailInfo detailInfo = ejgvDocument.getBody().getDetailInfo();
		
		Persons persons = ejgvDocument.getBody().getApplicantInfo().getPersons();
		
		if (persons!=null){
			List<Person> listPerson = persons.getPerson();
			if (listPerson!=null){
				int numPersonas = listPerson.size();
				int i = 0;
				Person person = null;
				while (i<numPersonas){
					person = listPerson.get(i); 
					if(person!=null){
						if(person.getPersonType()!=null){
							if(person.getHolderShip().equals("HOLDER")){
								titId = person.getId().toUpperCase();
							}
						}						
					}
					i++;
				}			
			}
		}

		if (this.titId==null || "".equals(this.titId.trim())){
			throw new P06BModMediadorException("No se recibe el identificador del mediador.");
		}
		
		this.expedienteFormateado = p06bDao.getExpedienteDeAlta(titId);
		
		p06B64T000Datatype.setExpediente(this.expedienteFormateado);
		
		idSolTramitagune = cData.getSolicitudID(); //Recoger el ID que ha dado tramitagune a la solicitud
				
		P06BLog.send(0,this, "(AutMediadores) Objeto con los datos de negocio parseados creado correctamente");
		
	}


	
	/**
	 * Constructor utilizado por el procedimiento de modificacin
	 * @throws SQLException 
	 * @throws P06BModMediadorException 
	 */
	public DatosMediadores(P06bAltaMediadoresDao p06bDao, EjgvDocument ejgvDocument, ContextSubmissionEvent cData, P06B64T00Datatype p06B64T000Datatype, boolean bCancelacion) throws SQLException, P06BModMediadorException {
		
		P06BLog.send(0,this, "(AltaMediadores) Creacin del objeto con los datos de cancelacin parseados");
		
		DetailInfo detailInfo = ejgvDocument.getBody().getDetailInfo();
		
		Persons persons = ejgvDocument.getBody().getApplicantInfo().getPersons();
		
		if (persons!=null){
			List<Person> listPerson = persons.getPerson();
			if (listPerson!=null){
				int numPersonas = listPerson.size();
				int i = 0;
				Person person = null;
				while (i<numPersonas){
					person = listPerson.get(i); 
					if(person!=null){
						if(person.getPersonType()!=null){
							if(person.getHolderShip().equals("HOLDER")){
								titId = person.getId().toUpperCase();
							}
						}						
					}
					i++;
				}			
			}
		}

		if (this.titId==null || "".equals(this.titId.trim())){
			throw new P06BModMediadorException("No se recibe el identificador del mediador.");
		}
		
		this.expedienteFormateado = p06bDao.getExpedienteDeAlta(titId);
		
		p06B64T000Datatype.setExpediente(this.expedienteFormateado);
		
		idSolTramitagune = cData.getSolicitudID(); //Recoger el ID que ha dado tramitagune a la solicitud
		
		DetailInfo.MotivosCancelacion.MotivoCancelacion motivoCancelacion = detailInfo.getMotivosCancelacion().getMotivoCancelacion();
		if (motivoCancelacion==null){
			throw new P06BModMediadorException("No se recibe el motivo de cancelacin.");			
		}
		motivoCancelacionRadio = motivoCancelacion.getMotivoCancelacionRadio();
		
		switch(motivoCancelacionRadio){
			case P06BConstantes.P06B_MC_ABANDONO:{
				otrosMotivos = "Abandono (cese, disolucin, inactividad, jubilacin, dejar de cumplir los requisitos legales, venta de cartera)";
				break;
			}
			case P06BConstantes.P06B_MC_CAMBIODEPOSICION:{		
				otrosMotivos = "Cambio de posicin (corredor, exclusivo, vinculado)";
				break;
			}
			case P06BConstantes.P06B_MC_CAMBIODEFORMAJURIDICA:{
				otrosMotivos = "Cambio de forma jurdica (constituye sociedad)";
				break;
			}
			case P06BConstantes.P06B_MC_CONCENTRACION:{
				otrosMotivos = "Concentracin (auxiliar asesor, concentracin de cartera)";
				break;
			}
			case P06BConstantes.P06B_MC_OTROSMOTIVOS:{
				if (motivoCancelacion.getOtrosMotivos()==null || "".equals(motivoCancelacion.getOtrosMotivos().trim())){
					throw new P06BModMediadorException("No se recibe la descripcin textual que debe acompaar al motivo de cancelacin 'Otros'.");
				}					
				otrosMotivos = "Otros motivos: " + motivoCancelacion.getOtrosMotivos();
				break;
			}
			default:{
				throw new P06BModMediadorException("No se recibe un motivo de cancelacin conocido.");				
			}
		}
		
		otrosMotivos = otrosMotivos.toUpperCase();
		
		P06BLog.send(0,this, "(AltaMediadores) Objeto con los datos de cancelacin parseados creado correctamente");
		
	}


	
	/**
	 * Mtodo que obtiene el identificador del procedimiento de alta de solicitud de reclamacin
	 * 
	 * @return Devuelve un objeto String con el identificador del procedimiento
	 *         de alta de solicitud de reclamacin
	 */
	public static String claseMediadorDesdeTitTipoIdYTipoMediador(String titTipoId, byte tipoMediador) {
		String titTipoIdLetra = "";
		if (titTipoId.equals("1")){
			titTipoIdLetra = P06BConstantes.P06B_PERSONA_FISICA;
		}else{
			titTipoIdLetra = P06BConstantes.P06B_PERSONA_JURIDICA;
		}
		
		String claseMediador = "";
		switch (tipoMediador){
			case P06BConstantes.P06B_TIPOCORR_AGENTE:
				claseMediador = P06BConstantes.P06B_TIPOCORR_A_LETRA + titTipoIdLetra;
				break;
			case P06BConstantes.P06B_TIPOCORR_CORREDOR:
				claseMediador = P06BConstantes.P06B_TIPOCORR_CORREDOR_LETRA + titTipoIdLetra;
				break;
			case P06BConstantes.P06B_TIPOCORR_REASEGUROS:
				claseMediador = P06BConstantes.P06B_TIPOCORR_R_LETRA + titTipoIdLetra;
				break;
			case P06BConstantes.P06B_TIPOCORR_OPERADORVINC:
				claseMediador = P06BConstantes.P06B_TIPOCORR_OV_LETRA;
				break;
			case P06BConstantes.P06B_TIPOCORR_OPERADOREXCL:
				claseMediador = P06BConstantes.P06B_TIPOCORR_OE_LETRA;
				break;
		}
		
		return claseMediador;
				
		
	}




	
	


	/**
	 * Mtodo que obtiene el identificador del procedimiento de alta de solicitud de reclamacin
	 * 
	 * @return Devuelve un objeto String con el identificador del procedimiento
	 *         de alta de solicitud de reclamacin
	 */
	public String obtenerClaseMediador() {
		return claseMediadorDesdeTitTipoIdYTipoMediador(titTipoId, dATipoMediador);
	}



	/**
	 * Mtodo que obtiene el identificador del procedimiento de alta de solicitud de reclamacin
	 * 
	 * @return Devuelve un objeto String con el identificador del procedimiento
	 *         de alta de solicitud de reclamacin
	 */
	public static String obtenerTipoPersonaEnBaseATipoIdTramitagune(byte TipoIdSocio) {
		String sTipoPersona = "";
		switch (TipoIdSocio){
			case 2:
				sTipoPersona = P06BConstantes.P06B_PERSONA_JURIDICA;
				break;
			case 1:
			case 3:
			case 4:
				sTipoPersona = P06BConstantes.P06B_PERSONA_FISICA;
				break;
			case 5:
				sTipoPersona = "?";
				break;
			default:
				sTipoPersona = "?";
				break;
		}
		
		return sTipoPersona;		
	}

	
	
	
	/**
	 * Mtodo que obtiene el identificador del procedimiento de alta de solicitud de reclamacin
	 * 
	 * @return Devuelve un objeto String con el identificador del procedimiento
	 *         de alta de solicitud de reclamacin
	 */
	public String formatearExpediente() {
		String sExpediente = String.valueOf(this.expediente);
		int numCerosInsertar = P06BConstantes.P06B_NUMPOSICIONES_CLAVE - sExpediente.length(); 
		for (int i=0;i<numCerosInsertar;i++){
			sExpediente = "0" + sExpediente;
		}
		return obtenerClaseMediador() + "-" + sExpediente + "EUS"; 
	}





	public String getTitNombre() {
		return titNombre;
	}








	public void setTitNombre(String titNombre) {
		this.titNombre = titNombre;
	}








	public String getTitApe1() {
		return titApe1;
	}




	/**
	 * @return the titRazonSocial
	 */
	public String getTitRazonSocial() {
		return titRazonSocial;
	}



	/**
	 * @param titRazonSocial the titRazonSocial to set
	 */
	public void setTitRazonSocial(String titRazonSocial) {
		this.titRazonSocial = titRazonSocial;
	}



	public void setTitApe1(String titApe1) {
		this.titApe1 = titApe1;
	}








	public String getTitApe2() {
		return titApe2;
	}








	public void setTitApe2(String titApe2) {
		this.titApe2 = titApe2;
	}








	public String getTitTipoId() {
		return titTipoId;
	}








	public void setTitTipoId(String titTipoId) {
		this.titTipoId = titTipoId;
	}








	public String getTitId() {
		return titId;
	}








	public void setTitId(String titId) {
		this.titId = titId;
	}








	public String getTitSexo() {
		return titSexo;
	}








	public void setTitSexo(String titSexo) {
		this.titSexo = titSexo;
	}








	public String getRepNombre() {
		return repNombre;
	}








	public void setRepNombre(String repNombre) {
		this.repNombre = repNombre;
	}








	public String getRepApe1() {
		return repApe1;
	}








	public void setRepApe1(String repApe1) {
		this.repApe1 = repApe1;
	}








	public String getRepApe2() {
		return repApe2;
	}








	public void setRepApe2(String repApe2) {
		this.repApe2 = repApe2;
	}








	public String getRepTipoId() {
		return repTipoId;
	}








	public void setRepTipoId(String repTipoId) {
		this.repTipoId = repTipoId;
	}








	public String getRepId() {
		return repId;
	}








	public void setRepId(String repId) {
		this.repId = repId;
	}








	public int getTipoNotif() {
		return tipoNotif;
	}








	public void setTipoNotif(int tipoNotif) {
		this.tipoNotif = tipoNotif;
	}








	public String getTipoAviso() {
		return tipoAviso;
	}








	public void setTipoAviso(String tipoAviso) {
		this.tipoAviso = tipoAviso;
	}








	public String getValorAviso() {
		return valorAviso;
	}








	public void setValorAviso(String valorAviso) {
		this.valorAviso = valorAviso;
	}








	public String getIdiomaSol() {
		return idiomaSol;
	}








	public void setIdiomaSol(String idiomaSol) {
		this.idiomaSol = idiomaSol;
	}








	public String getFechaEfectos() {
		return fechaEfectos;
	}








	public void setFechaEfectos(String fechaEfectos) {
		this.fechaEfectos = fechaEfectos;
	}








	public byte getdATipoMediador() {
		return dATipoMediador;
	}








	public void setdATipoMediador(byte dATipoMediador) {
		this.dATipoMediador = dATipoMediador;
	}








	public String getdAProvincia() {
		return dAProvincia;
	}








	public void setdAProvincia(String dAProvincia) {
		this.dAProvincia = dAProvincia;
	}








	public String getdAMunicipio() {
		return dAMunicipio;
	}








	public void setdAMunicipio(String dAMunicipio) {
		this.dAMunicipio = dAMunicipio;
	}








	public String getdALocalidad() {
		return dALocalidad;
	}








	public void setdALocalidad(String dALocalidad) {
		this.dALocalidad = dALocalidad;
	}








	public String getdACalle() {
		return dACalle;
	}








	public void setdACalle(String dACalle) {
		this.dACalle = dACalle;
	}








	public String getdAPortal() {
		return dAPortal;
	}








	public void setdAPortal(String dAPortal) {
		this.dAPortal = dAPortal;
	}








	public String getdAPiso() {
		return dAPiso;
	}








	public void setdAPiso(String dAPiso) {
		this.dAPiso = dAPiso;
	}








	public String getdALetra() {
		return dALetra;
	}








	public void setdALetra(String dALetra) {
		this.dALetra = dALetra;
	}








	public String getdACodigoPostal() {
		return dACodigoPostal;
	}








	public void setdACodigoPostal(String dACodigoPostal) {
		this.dACodigoPostal = dACodigoPostal;
	}








	public String getdATelefono() {
		return dATelefono;
	}








	public void setdATelefono(String dATelefono) {
		this.dATelefono = dATelefono;
	}








	public String getdAEMail() {
		return dAEMail;
	}








	public void setdAEMail(String dAEMail) {
		this.dAEMail = dAEMail;
	}








	public String getdAWeb() {
		return dAWeb;
	}








	public void setdAWeb(String dAWeb) {
		this.dAWeb = dAWeb;
	}








	public String getaCTNombre() {
		return aCTNombre;
	}








	public void setaCTNombre(String aCTNombre) {
		this.aCTNombre = aCTNombre;
	}








	public String getaCTApe1() {
		return aCTApe1;
	}








	public void setaCTApe1(String aCTApe1) {
		this.aCTApe1 = aCTApe1;
	}








	public String getaCTApe2() {
		return aCTApe2;
	}








	public void setaCTApe2(String aCTApe2) {
		this.aCTApe2 = aCTApe2;
	}








	public String getaCTId() {
		return aCTId;
	}








	public void setaCTId(String aCTId) {
		this.aCTId = aCTId;
	}








	public String getaCDNombre() {
		return aCDNombre;
	}








	public void setaCDNombre(String aCDNombre) {
		this.aCDNombre = aCDNombre;
	}








	public String getaCDApe1() {
		return aCDApe1;
	}








	public void setaCDApe1(String aCDApe1) {
		this.aCDApe1 = aCDApe1;
	}








	public String getaCDApe2() {
		return aCDApe2;
	}








	public void setaCDApe2(String aCDApe2) {
		this.aCDApe2 = aCDApe2;
	}















	public String getaCDId() {
		return aCDId;
	}








	public void setaCDId(String aCDId) {
		this.aCDId = aCDId;
	}








	/**
	 * @return the pSCapitalSocial
	 */
	public String getpSCapitalSocial() {
		return pSCapitalSocial;
	}



	/**
	 * @param pSCapitalSocial the pSCapitalSocial to set
	 */
	public void setpSCapitalSocial(String pSCapitalSocial) {
		this.pSCapitalSocial = pSCapitalSocial;
	}



	/**
	 * @return the pSNumeroParticipaciones
	 */
	public String getpSNumeroParticipaciones() {
		return pSNumeroParticipaciones;
	}



	/**
	 * @param pSNumeroParticipaciones the pSNumeroParticipaciones to set
	 */
	public void setpSNumeroParticipaciones(String pSNumeroParticipaciones) {
		this.pSNumeroParticipaciones = pSNumeroParticipaciones;
	}



	public Integer getCodReclamante() {
		return codReclamante;
	}








	public void setCodReclamante(Integer codReclamante) {
		this.codReclamante = codReclamante;
	}








	public String getNombreRclte() {
		return nombreRclte;
	}








	public void setNombreRclte(String nombreRclte) {
		this.nombreRclte = nombreRclte;
	}








	public int getExpediente() {
		return expediente;
	}








	public void setExpediente(int expediente) {
		this.expediente = expediente;
	}








	/**
	 * @return the expedienteFormateado
	 */
	public String getExpedienteFormateado() {
		return expedienteFormateado;
	}



	/**
	 * @param expedienteFormateado the expedienteFormateado to set
	 */
	public void setExpedienteFormateado(String expedienteFormateado) {
		this.expedienteFormateado = expedienteFormateado;
	}



	public Integer getDuplicado() {
		return duplicado;
	}








	public void setDuplicado(Integer duplicado) {
		this.duplicado = duplicado;
	}








//	public int getCodSolicitud() {
//		return codSolicitud;
//	}
//
//
//
//
//
//
//
//
//	public void setCodSolicitud(int codSolicitud) {
//		this.codSolicitud = codSolicitud;
//	}








	public String getIdSolTramitagune() {
		return idSolTramitagune;
	}








	public void setIdSolTramitagune(String idSolTramitagune) {
		this.idSolTramitagune = idSolTramitagune;
	}








	public String getaCTAtencioncliente() {
		return aCTAtencioncliente;
	}



	public void setaCTAtencioncliente(String aCTAtencioncliente) {
		this.aCTAtencioncliente = aCTAtencioncliente;
	}



	public byte getaCTTipoId() {
		return aCTTipoId;
	}








	public void setaCTTipoId(byte aCTTipoId) {
		this.aCTTipoId = aCTTipoId;
	}








	public byte getaCDTipoId() {
		return aCDTipoId;
	}








	public void setaCDTipoId(byte aCDTipoId) {
		this.aCDTipoId = aCDTipoId;
	}



	public List<P06B22T00Datatype> getListP06B22T00Datatype() {
		return listP06B22T00Datatype;
	}



	public void setListP06B22T00Datatype(
			List<P06B22T00Datatype> listP06B22T00Datatype) {
		this.listP06B22T00Datatype = listP06B22T00Datatype;
	}



	/**
	 * @return the listP06B24T00DatatypeOD
	 */
	public List<P06B24T00Datatype> getListP06B24T00DatatypeOD() {
		return listP06B24T00DatatypeOD;
	}



	/**
	 * @param listP06B24T00DatatypeOD the listP06B24T00DatatypeOD to set
	 */
	public void setListP06B24T00DatatypeOD(
			List<P06B24T00Datatype> listP06B24T00DatatypeOD) {
		this.listP06B24T00DatatypeOD = listP06B24T00DatatypeOD;
	}



	/**
	 * @return the listP06B24T00DatatypeA
	 */
	public List<P06B24T00Datatype> getListP06B24T00DatatypeA() {
		return listP06B24T00DatatypeA;
	}



	/**
	 * @param listP06B24T00DatatypeA the listP06B24T00DatatypeA to set
	 */
	public void setListP06B24T00DatatypeA(
			List<P06B24T00Datatype> listP06B24T00DatatypeA) {
		this.listP06B24T00DatatypeA = listP06B24T00DatatypeA;
	}



	public List<P06B61T00Datatype> getListP06B61T00Datatype() {
		return listP06B61T00Datatype;
	}



	public void setListP06B61T00Datatype(
			List<P06B61T00Datatype> listP06B61T00Datatype) {
		this.listP06B61T00Datatype = listP06B61T00Datatype;
	}



	public byte getcFDeclaro() {
		return cFDeclaro;
	}



	public void setcFDeclaro(byte cFDeclaro) {
		this.cFDeclaro = cFDeclaro;
	}



	public float getcFImpFondos() {
		return cFImpFondos;
	}



	public void setcFImpFondos(float cFImpFondos) {
		this.cFImpFondos = cFImpFondos;
	}



	public float getcFImpCapacidad() {
		return cFImpCapacidad;
	}



	public void setcFImpCapacidad(float cFImpCapacidad) {
		this.cFImpCapacidad = cFImpCapacidad;
	}



	public boolean iscFContrataSeguro() {
		return cFContrataSeguro;
	}



	public void setcFContrataSeguro(boolean cFContrataSeguro) {
		this.cFContrataSeguro = cFContrataSeguro;
	}



	public String getcFTextoSeguro() {
		return cFTextoSeguro;
	}



	public void setcFTextoSeguro(String cFTextoSeguro) {
		this.cFTextoSeguro = cFTextoSeguro;
	}



	public boolean iscFContrataAval() {
		return cFContrataAval;
	}



	public void setcFContrataAval(boolean cFContrataAval) {
		this.cFContrataAval = cFContrataAval;
	}



	public String getcFTextoAval() {
		return cFTextoAval;
	}



	public void setcFTextoAval(String cFTextoAval) {
		this.cFTextoAval = cFTextoAval;
	}



	/**
	 * @return the bActualizarDomicilioSocial
	 */
	public boolean isbActualizarDomicilioSocial() {
		return bActualizarDomicilioSocial;
	}



	/**
	 * @param bActualizarDomicilioSocial the bActualizarDomicilioSocial to set
	 */
	public void setbActualizarDomicilioSocial(boolean bActualizarDomicilioSocial) {
		this.bActualizarDomicilioSocial = bActualizarDomicilioSocial;
	}



	/**
	 * @return the bActualizarCapitalSocial
	 */
	public boolean isbActualizarCapitalSocial() {
		return bActualizarCapitalSocial;
	}



	/**
	 * @param bActualizarCapitalSocial the bActualizarCapitalSocial to set
	 */
	public void setbActualizarCapitalSocial(boolean bActualizarCapitalSocial) {
		this.bActualizarCapitalSocial = bActualizarCapitalSocial;
	}



	/**
	 * @return the bActualizarAdministradores
	 */
	public boolean isbActualizarAdministradores() {
		return bActualizarAdministradores;
	}



	/**
	 * @param bActualizarAdministradores the bActualizarAdministradores to set
	 */
	public void setbActualizarAdministradores(boolean bActualizarAdministradores) {
		this.bActualizarAdministradores = bActualizarAdministradores;
	}



	/**
	 * @return the bActualizarOrganoDireccion
	 */
	public boolean isbActualizarOrganoDireccion() {
		return bActualizarOrganoDireccion;
	}



	/**
	 * @param bActualizarOrganoDireccion the bActualizarOrganoDireccion to set
	 */
	public void setbActualizarOrganoDireccion(boolean bActualizarOrganoDireccion) {
		this.bActualizarOrganoDireccion = bActualizarOrganoDireccion;
	}



	/**
	 * @return the bActualizarAtencionDefensaCliente
	 */
	public boolean isbActualizarAtencionDefensaCliente() {
		return bActualizarAtencionDefensaCliente;
	}



	/**
	 * @param bActualizarAtencionDefensaCliente the bActualizarAtencionDefensaCliente to set
	 */
	public void setbActualizarAtencionDefensaCliente(
			boolean bActualizarAtencionDefensaCliente) {
		this.bActualizarAtencionDefensaCliente = bActualizarAtencionDefensaCliente;
	}



	/**
	 * @return the bActualizarCapacidadFinanciera
	 */
	public boolean isbActualizarCapacidadFinanciera() {
		return bActualizarCapacidadFinanciera;
	}



	/**
	 * @param bActualizarCapacidadFinanciera the bActualizarCapacidadFinanciera to set
	 */
	public void setbActualizarCapacidadFinanciera(
			boolean bActualizarCapacidadFinanciera) {
		this.bActualizarCapacidadFinanciera = bActualizarCapacidadFinanciera;
	}



	/**
	 * @return the bActualizarEntidadesVinculadas
	 */
	public boolean isbActualizarEntidadesVinculadas() {
		return bActualizarEntidadesVinculadas;
	}



	/**
	 * @param bActualizarEntidadesVinculadas the bActualizarEntidadesVinculadas to set
	 */
	public void setbActualizarEntidadesVinculadas(
			boolean bActualizarEntidadesVinculadas) {
		this.bActualizarEntidadesVinculadas = bActualizarEntidadesVinculadas;
	}



	/**
	 * @return the motivoCancelacionRadio
	 */
	public byte getMotivoCancelacionRadio() {
		return motivoCancelacionRadio;
	}



	/**
	 * @param motivoCancelacionRadio the motivoCancelacionRadio to set
	 */
	public void setMotivoCancelacionRadio(byte motivoCancelacionRadio) {
		this.motivoCancelacionRadio = motivoCancelacionRadio;
	}



	/**
	 * @return the otrosMotivos
	 */
	public String getOtrosMotivos() {
		return otrosMotivos;
	}



	/**
	 * @param otrosMotivos the otrosMotivos to set
	 */
	public void setOtrosMotivos(String otrosMotivos) {
		this.otrosMotivos = otrosMotivos;
	}

	
	
}
